/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#include <linux/delay.h>
#include <mach/clock.h>
#include <asm/system.h>
#include <asm/irq.h>
#include <asm/io.h>
#include <asm/page.h>
#include <mach/intctl-regs.h>

#include <linux/i2c.h>
#include <linux/i2c-dev.h>


#define AVEV3_USE_EEPROM


extern int eep_get_mac(unsigned char *mac_addr);
extern int eepdrv_get_mac(unsigned char *mac_addr);

int avev3_util_mac_read(unsigned char *mac_buf);
int avev3_util_mac_read(unsigned char *mac_buf)
{
  mac_buf[0] = 0xff;
  mac_buf[1] = 0xff;
  mac_buf[2] = 0xff;
  mac_buf[3] = 0xff;
  mac_buf[4] = 0xff;
  mac_buf[5] = 0xff;

#ifdef AVEV3_USE_EEPROM 

#ifdef MODULE
  eepdrv_get_mac(mac_buf);
#else 
  eep_get_mac(mac_buf);
#endif 

#endif 

  return(0);
}




#ifdef AVEV3_USE_EEPROM 

#if defined(CONFIG_MACH_MN2WS0251_REF) || defined(CONFIG_MACH_MN2WS0270_REF)
#define AVE_IIC_CH      (0)       
#define EEPROM_ADDR     (0x50)    

#else 
#ifdef CONFIG_USE_BOARD_OPTION_C
#define AVE_IIC_CH      (1)       
#else
#define AVE_IIC_CH      (2)       
#endif

#define EEPROM_ADDR     (0x51)    

#endif 


int eepdrv_get_mac(unsigned char *mac_addr)
{
    struct i2c_adapter      *PI2cAdap;
    struct i2c_msg          I2cMsg[2];
    unsigned char           aBuf1[8];
    int                     status;

    PI2cAdap = i2c_get_adapter(AVE_IIC_CH);
    if (!PI2cAdap) {
        printk(KERN_WARNING "avether-i2c: i2c_get_adapter failed\n");
        return( -1 );
    }

    I2cMsg[0].addr = EEPROM_ADDR;    
    I2cMsg[0].flags = 0;
    I2cMsg[0].len = 2;
    I2cMsg[0].buf = aBuf1;
    aBuf1[0] = 0xff;          
    aBuf1[1] = 0xf9;
    I2cMsg[1].addr = EEPROM_ADDR;    
    I2cMsg[1].flags = I2C_M_RD;
    I2cMsg[1].len = 6;
    I2cMsg[1].buf = mac_addr;

    status = i2c_transfer(PI2cAdap, I2cMsg, 2);
    if (0 > status) {
        printk(KERN_WARNING "avether-i2c: i2c_transfer(1) failed (%d)\n",
                    status);
        i2c_put_adapter( PI2cAdap );
        return( -1 );
    }

    i2c_put_adapter( PI2cAdap );
    return( 0 );
}


#if defined(CONFIG_MACH_MN2WS0251_REF) || defined(CONFIG_MACH_MN2WS0270_REF)
#define EEPROM_ADDRESS  (0xA0)
#define USE_IIC_CH      (0)       
#define MAC_OFFSET      (0xFFF9)

#else 
#define EEPROM_ADDRESS  (0xA2)
#define MAC_OFFSET      (0xFFF9)

#ifdef CONFIG_USE_BOARD_OPTION_C
#define USE_IIC_CH      (1)       
#else
#define USE_IIC_CH      (2)       
#endif
#endif 

#define IIC_OFFSET      (0x80000 * USE_IIC_CH)

#define IIC_BASE        (0x58400000)
#define IIC_DTRM        __SYSREG(IIC_BASE + IIC_OFFSET)
#define IIC_DREC        __SYSREG(IIC_BASE + 0x04 + IIC_OFFSET)
#define IIC_MYADD       __SYSREG(IIC_BASE + 0x08 + IIC_OFFSET)
#define IIC_CLK         __SYSREG(IIC_BASE + 0x0c + IIC_OFFSET)
#define IIC_BRST        __SYSREG(IIC_BASE + 0x10 + IIC_OFFSET)
#define IIC_HOLD        __SYSREG(IIC_BASE + 0x14 + IIC_OFFSET)
#define IIC_BSTS        __SYSREG(IIC_BASE + 0x18 + IIC_OFFSET)

#define IIC_IRQ                 (73 + USE_IIC_CH)
#if defined(CONFIG_PROC_MN2WS0251) || defined(CONFIG_PROC_MN2WS0270)
#define IIC_GIC_PEND_CLR        __SYSREG(0x60001280 + (IIC_IRQ / 32) * 4)
#else 
#define IIC_GIC_PEND_CLR        __SYSREG(0x20001280 + (IIC_IRQ / 32) * 4)
#endif 
#define IIC_GIC_PEND_MASK       (1 << (IIC_IRQ % 32))

#define IIC_CLK_PLS	((unsigned short)(MN_IOCLK / 100000 - 1))
#define IIC_CLK_LOW	((unsigned short)(IIC_CLK_PLS / 2))

#define SYS_IIC_DTRM_Bit_STA	((unsigned short)0x0400)
#define SYS_IIC_DTRM_Bit_STO	((unsigned short)0x0200)
#define SYS_IIC_DTRM_Bit_ACK	((unsigned short)0x0100)
#define SYS_IIC_DTRM_Bit_DATA	((unsigned short)0x00FF)


#define POLL_INT_REQ(icr)                                       \
do {                                                            \
        while (!(inl(IIC_GIC_PEND_CLR) & IIC_GIC_PEND_MASK));   \
        mn_intc_clear(IIC_IRQ);                                 \
} while (0)

static unsigned long iic_reg_base;

static inline void __iomem *__iic_io(unsigned long addr)
{
	switch (addr) {
	case (IIC_BASE + IIC_OFFSET) ...
		(IIC_BASE + IIC_OFFSET + PAGE_SIZE - 1):
		return (void __iomem *)(addr - (IIC_BASE + IIC_OFFSET) +
			iic_reg_base);
	default:
		BUG();
	}
}

#define iic_reg_read(addr)	readl(__iic_io(addr))
#define iic_reg_write(v, addr)	writel((v), __iic_io(addr))

int eep_get_mac(unsigned char mac_addr[])
{
	unsigned char *mac_buf = mac_addr;
	int i;
	unsigned short value;
	unsigned int data;
	int mac_length = 6;
	int check;

	iic_reg_base = (unsigned long)ioremap(IIC_BASE + IIC_OFFSET, PAGE_SIZE);
	if (!iic_reg_base)
		return -1;

	iic_reg_write(0x00000008, IIC_MYADD);
	iic_reg_write((IIC_CLK_LOW << 16) + (IIC_CLK_PLS), IIC_CLK);
	while (1){
		check = 0;
		for (i = 0;i < 3;i++){
			if ((iic_reg_read(IIC_BSTS) & 0x3) == 0x3){
				check++;
			}
			udelay(3);
		}

		if (check == 3){
			iic_reg_write(0x00000003, IIC_BRST);
			break;
		}
		else {
			for (i = 0;i < 3;i++){
				iic_reg_write(0x00000002, IIC_BRST);
				udelay(8);
				iic_reg_write(0x00000003, IIC_BRST);
				udelay(8);
			}
		}
	}

	iic_reg_write(0x00000002, IIC_BRST);
	iic_reg_write(0x00000003, IIC_BRST);

	value	=  SYS_IIC_DTRM_Bit_STA | SYS_IIC_DTRM_Bit_ACK;
	value	|= ((unsigned short)EEPROM_ADDRESS & SYS_IIC_DTRM_Bit_DATA) | (unsigned short)0x0000;
	iic_reg_write(value, IIC_DTRM);
	POLL_INT_REQ();

	iic_reg_write((unsigned char)((MAC_OFFSET & 0xFF00) >> 8), IIC_DTRM);
	POLL_INT_REQ();

	iic_reg_write((unsigned char)(MAC_OFFSET & 0x00FF), IIC_DTRM);
	POLL_INT_REQ();

	udelay (1000);

	value	=  SYS_IIC_DTRM_Bit_STA;
	value	|= ((unsigned short)EEPROM_ADDRESS & SYS_IIC_DTRM_Bit_DATA) | (unsigned short)0x0001;
	iic_reg_write(value, IIC_DTRM);
	POLL_INT_REQ();

	iic_reg_write(0x00000000, IIC_DTRM);
	while (mac_length > 0) {
		POLL_INT_REQ();

		data = iic_reg_read(IIC_DREC);
		mac_length--;
		if (mac_length == 0) {
			value = 0x00000300;
		}
		else if (mac_length == 1) {
			value = 0x00000100;
		}
		else {
			value = 0x00000000;
		}
		iic_reg_write(value, IIC_DTRM);
		*mac_buf++ = (unsigned char)(data & 0xff);
	}

	iounmap((void *)iic_reg_base);

	return 0;
}
#endif 
